/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.bukkit.skinrefresher;

import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.skinsrestorer.bukkit.SkinsRestorer;
import net.skinsrestorer.bukkit.skinrefresher.ViaWorkaround;
import net.skinsrestorer.bukkit.utils.MappingManager;
import net.skinsrestorer.bukkit.utils.NoMappingException;
import net.skinsrestorer.mappings.shared.IMapping;
import net.skinsrestorer.mappings.shared.ViaPacketData;
import net.skinsrestorer.shared.utils.log.SRLogger;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class MappingSpigotSkinRefresher
implements Consumer<Player> {
    private final SkinsRestorer plugin;
    private final IMapping mapping;
    private boolean useViabackwards = false;

    public MappingSpigotSkinRefresher(SkinsRestorer plugin, SRLogger log) throws NoMappingException {
        this.plugin = plugin;
        Optional<IMapping> mapping = MappingManager.getMapping();
        if (!mapping.isPresent()) {
            throw new NoMappingException();
        }
        this.mapping = mapping.get();
        Bukkit.getScheduler().runTask((Plugin)plugin, () -> {
            if (plugin.getServer().getPluginManager().isPluginEnabled("ViaBackwards") && ViaWorkaround.isProtocolNewer()) {
                this.useViabackwards = true;
                log.debug("Activating ViaBackwards workaround.");
            }
        });
        log.debug("Using MappingSpigotSkinRefresher");
    }

    @Override
    public void accept(Player player) {
        Predicate<ViaPacketData> viaFunction = this.useViabackwards ? ViaWorkaround::sendCustomPacketVia : data -> true;
        this.mapping.accept(player, viaFunction);
        if (player.isOp()) {
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                player.setOp(false);
                player.setOp(true);
            });
        }
    }
}

